/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.mod.illager_more.entities;

import com.pikachu.mod.illager_more.CombatEvent;
import com.pikachu.mod.illager_more.config.IllagerAdditionsConfig;
import com.pikachu.mod.illager_more.init.ModItems;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SpearmanMasterEntity
extends AbstractIllager
implements IAnimatable {
    protected static final UUID SPEED_MODIFIER_RUNNING_UUID = UUID.fromString("05cd370b-0ff1-4ded-8630-b380232ed7b1");
    protected static final AttributeModifier SPEED_MODIFIER_RUN = new AttributeModifier(SPEED_MODIFIER_RUNNING_UUID, "Running speed increase", 0.135, AttributeModifier.Operation.ADDITION);
    protected static final EntityDataAccessor<Boolean> IS_PULLED_OUT_WEAPON = SynchedEntityData.m_135353_(SpearmanMasterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> IS_PULLING_OUT_WEAPON = SynchedEntityData.m_135353_(SpearmanMasterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> CAN_MELEE = SynchedEntityData.m_135353_(SpearmanMasterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> IS_MELEE = SynchedEntityData.m_135353_(SpearmanMasterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> MELEE_TYPE = SynchedEntityData.m_135353_(SpearmanMasterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> IS_RUN = SynchedEntityData.m_135353_(SpearmanMasterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected int timer = 0;
    protected int aiPower;
    protected boolean noDamages;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public SpearmanMasterEntity(EntityType<? extends AbstractIllager> p_32105_, Level p_32106_) {
        super(p_32105_, p_32106_);
        this.aiPower = (Integer)IllagerAdditionsConfig.guard_ai_strength.get();
        this.f_21364_ = 20;
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    public boolean m_7307_(Entity p_33314_) {
        if (super.m_7307_(p_33314_)) {
            return true;
        }
        if (p_33314_ instanceof LivingEntity && ((LivingEntity)p_33314_).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && p_33314_.m_5647_() == null;
        }
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, MobSpawnType p_37858_, @Nullable SpawnGroupData p_37859_, @Nullable CompoundTag p_37860_) {
        this.populateDefaultEquipmentSlots(p_37857_);
        return super.m_6518_(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.235f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 28.0).m_22268_(Attributes.f_22281_, 3.5);
    }

    public boolean isNoDamages() {
        return this.noDamages;
    }

    public void setNoDamages(boolean noDamages) {
        this.noDamages = noDamages;
    }

    public boolean m_6469_(DamageSource p_37849_, float p_37850_) {
        if (!p_37849_.m_19376_() && !p_37849_.m_19360_() && this.isNoDamages() && this.aiPower > 2) {
            return false;
        }
        return super.m_6469_(p_37849_, p_37850_);
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new DoHurtTargetGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new PullOutWeaponGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new WithdrawWeaponGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SpearmanMeleeGoal(this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public boolean m_7490_() {
        return false;
    }

    protected void populateDefaultEquipmentSlots(@Nonnull DifficultyInstance p_180481_1_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.SPEAR.get()));
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.GUARD_HELMET.get()));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.GUARD_CHESTPLATE.get()));
        this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.GUARD_LEGS.get()));
    }

    @Nonnull
    public SoundEvent m_7930_() {
        return SoundEvents.f_12577_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12576_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12578_;
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource p_184601_1_) {
        return SoundEvents.f_12579_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CAN_MELEE, (Object)false);
        this.f_19804_.m_135372_(IS_PULLED_OUT_WEAPON, (Object)false);
        this.f_19804_.m_135372_(IS_PULLING_OUT_WEAPON, (Object)false);
        this.f_19804_.m_135372_(IS_MELEE, (Object)false);
        this.f_19804_.m_135372_(MELEE_TYPE, (Object)0);
        this.f_19804_.m_135372_(IS_RUN, (Object)false);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        event.getController().setAnimationSpeed(1.0);
        SpearmanMasterEntity livingEntity = this;
        Vec3 velocity = livingEntity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if (((Boolean)this.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON)).booleanValue()) {
            if (((Boolean)this.f_19804_.m_135370_(IS_MELEE)).booleanValue()) {
                if ((Integer)this.f_19804_.m_135370_(MELEE_TYPE) == 1) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("attack", Boolean.valueOf(true)));
                } else if ((Integer)this.f_19804_.m_135370_(MELEE_TYPE) == 2) {
                    event.getController().setAnimationSpeed(1.5);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("attack2", Boolean.valueOf(true)));
                } else if ((Integer)this.f_19804_.m_135370_(MELEE_TYPE) == 3) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("attack3", Boolean.valueOf(true)));
                } else if ((Integer)this.f_19804_.m_135370_(MELEE_TYPE) == 4) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("attack4", Boolean.valueOf(true)));
                } else if ((Integer)this.f_19804_.m_135370_(MELEE_TYPE) == 5) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("attack5", Boolean.valueOf(true)));
                } else if ((Integer)this.f_19804_.m_135370_(MELEE_TYPE) == 6) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("attack", Boolean.valueOf(true)));
                } else if ((Integer)this.f_19804_.m_135370_(MELEE_TYPE) == 7) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("powerful_attack", Boolean.valueOf(true)));
                } else {
                    event.getController().setAnimationSpeed(2.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation((Integer)this.f_19804_.m_135370_(MELEE_TYPE) % 2 != 0 ? "attack6" : "attack7", Boolean.valueOf(true)));
                }
            } else if (((Boolean)this.f_19804_.m_135370_(IS_PULLING_OUT_WEAPON)).booleanValue()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("no_target", Boolean.valueOf(true)));
            } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                event.getController().setAnimationSpeed(Math.max(Math.min((double)(groundSpeed * 20.0f), 2.1), 0.15));
                event.getController().setAnimation(new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
            }
        } else if (((Boolean)this.f_19804_.m_135370_(IS_PULLING_OUT_WEAPON)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("set_target", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed(Math.max(Math.min((double)(groundSpeed * 20.0f), 2.1), 0.15));
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walk_no_target", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle_no_target", Boolean.valueOf(true)));
        }
        if (!this.m_6084_()) {
            event.getController().setAnimationSpeed(1.0E-5);
        }
        return PlayState.CONTINUE;
    }

    public boolean m_6785_(double p_37894_) {
        return super.m_6785_(p_37894_);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class DoHurtTargetGoal
    extends Goal {
        protected final SpearmanMasterEntity mob;
        protected LivingEntity target;
        protected int type;
        protected int cooldown;
        private float dodgeYaw;
        protected boolean hasNext;
        protected boolean inv;

        public DoHurtTargetGoal(SpearmanMasterEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
            this.cooldown = 0;
        }

        public boolean m_8036_() {
            return (Boolean)this.mob.f_19804_.m_135370_(CAN_MELEE) != false && this.mob.m_5448_() != null && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false && this.cooldown <= this.mob.f_19797_;
        }

        public boolean m_8045_() {
            if (!this.hasNext) {
                return this.isAttacking() && this.mob.m_5448_() != null;
            }
            if (!this.isAttacking()) {
                this.mob.timer = 0;
                this.type = this.type == 1 && this.mob.m_217043_().m_188503_(3) == 0 ? ++this.type : (this.type == 1 && this.mob.aiPower >= 2 ? (this.mob.m_217043_().m_188499_() ? 7 : 8 + this.mob.m_217043_().m_188503_(3)) : ++this.type);
                if (this.mob.m_5448_() != null) {
                    this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.mob.m_5448_().m_20182_());
                }
                return this.mob.m_5448_() != null;
            }
            return this.mob.m_5448_() != null;
        }

        private boolean isAttacking() {
            return this.mob.timer < (int)(1.25 * (double)(3 - this.mob.aiPower) + (double)(this.type == 1 ? 11 : (this.type == 2 ? 7 : (this.type == 3 ? 7 : (this.type == 4 ? 10 : (this.type == 6 ? 11 : (this.type == 7 ? 15 : 5))))))) || this.type == 5 && (this.mob.timer < 8 || !this.mob.m_20096_());
        }

        public boolean m_6767_() {
            return this.mob.f_20916_ > 0 && this.mob.m_5448_() != null && this.mob.m_20270_((Entity)this.mob.m_5448_()) < 6.0f;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.type = 1;
            this.inv = this.mob.m_20147_();
            if (this.mob.m_217043_().m_188503_(8) == 0 && !(this.mob.m_5448_() instanceof Player) && this.mob.aiPower > 2) {
                this.type = 6;
            }
            this.mob.f_19804_.m_135381_(IS_MELEE, (Object)true);
            this.mob.f_19804_.m_135381_(CAN_MELEE, (Object)false);
            this.mob.f_19804_.m_135381_(MELEE_TYPE, (Object)6);
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return;
            }
            ++this.mob.timer;
            this.mob.m_21573_().m_26573_();
            this.mob.f_19804_.m_135381_(IS_MELEE, (Object)true);
            this.mob.f_19804_.m_135381_(MELEE_TYPE, (Object)this.type);
            if (this.type == 1) {
                if (this.mob.timer == 10) {
                    this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
                    CombatEvent.AreaAttack((LivingEntity)this.mob, 5.0f, 5.0f, 5.0f, 5.0f, 170.0f, 1.0f, 0.0, 0.5, true);
                    this.hasNext = livingentity.f_20916_ > 0;
                }
                this.moving(7);
            } else if (this.type == 2) {
                if (this.mob.timer == 6) {
                    this.mob.setNoDamages(this.inv);
                    this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
                    CombatEvent.AreaAttack((LivingEntity)this.mob, 5.0f, 5.0f, 5.0f, 5.0f, 230.0f, 0.45f, 0.0, 0.5, false);
                }
                if (this.mob.timer < 6) {
                    this.mob.setNoDamages(true);
                }
                this.moving(4);
                this.hasNext = true;
            } else if (this.type == 3) {
                if (this.mob.timer < 6) {
                    this.mob.setNoDamages(true);
                }
                if (this.mob.timer == 6) {
                    this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
                    CombatEvent.AreaAttack((LivingEntity)this.mob, 5.0f, 5.0f, 5.0f, 5.0f, 180.0f, 0.58f, 0.8, 0.5, false);
                }
                this.moving(2);
                this.hasNext = true;
            } else if (this.type == 4) {
                if (this.mob.timer == 5) {
                    Vec3 m = this.mob.m_20184_().m_82520_(Math.max(Math.min(livingentity.m_20185_() - this.mob.m_20185_(), 1.7), -1.7), 0.0, Math.max(Math.min(livingentity.m_20189_() - this.mob.m_20189_(), 1.7), -1.7)).m_82490_(0.28);
                    this.mob.m_20334_(m.f_82479_, 0.738, m.f_82481_);
                }
                if (this.mob.timer == 10) {
                    this.mob.setNoDamages(this.inv);
                    this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
                    CombatEvent.AreaAttack((LivingEntity)this.mob, 5.0f, 5.0f, 5.0f, 5.0f, 120.0f, 0.85f, -1.0, 0.5, false);
                }
                this.hasNext = false;
            } else if (this.type == 5) {
                Vec3 m;
                if (this.mob.timer == 1) {
                    m = this.mob.m_20184_().m_82520_(Math.max(Math.min(livingentity.m_20185_() - this.mob.m_20185_(), 1.8), -1.8), 0.0, Math.max(Math.min(livingentity.m_20189_() - this.mob.m_20189_(), 1.8), -1.8)).m_82490_(0.18);
                    this.mob.m_20334_(0.0, 0.2, 0.0);
                }
                if (this.mob.timer == 3) {
                    m = this.mob.m_20184_().m_82520_(Math.max(Math.min(livingentity.m_20185_() - this.mob.m_20185_(), 1.8), -1.8), 0.0, Math.max(Math.min(livingentity.m_20189_() - this.mob.m_20189_(), 1.8), -1.8)).m_82490_(0.42);
                    this.mob.m_20334_(m.f_82479_, -0.27, m.f_82481_);
                }
                List v = this.mob.f_19853_.m_45976_(AreaEffectCloud.class, this.mob.m_20191_());
                if (this.mob.m_20096_() && v.isEmpty()) {
                    this.mob.m_5496_(SoundEvents.f_11913_, 1.0f, 1.0f);
                    CombatEvent.AreaAttack((LivingEntity)this.mob, 5.0f, 5.0f, 5.0f, 5.0f, 170.0f, 2.22f, 0.35, 0.5, true);
                    AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.mob.f_19853_, this.mob.m_20185_(), this.mob.m_20227_(0.5), this.mob.m_20189_());
                    areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123813_);
                    areaeffectcloudentity.m_19712_(3.25f);
                    areaeffectcloudentity.m_19734_(6);
                    this.mob.f_19853_.m_7967_((Entity)areaeffectcloudentity);
                }
                this.hasNext = false;
            } else if (this.type == 6) {
                this.mob.setNoDamages(true);
                this.moving(7);
                if (this.mob.timer == 10) {
                    this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
                    CombatEvent.AreaAttack((LivingEntity)this.mob, 5.0f, 5.0f, 5.0f, 5.0f, 170.0f, 0.555f, 0.0, 0.5, true);
                    this.target = this.mob.m_21214_();
                    this.hasNext = this.target != null && this.target.m_6084_();
                    this.mob.setNoDamages(this.inv);
                }
                if (this.hasNext && this.mob.timer > 10) {
                    float radius = 2.25f;
                    float math = 0.175f;
                    float angle = (float)Math.PI / 180 * this.mob.m_146908_();
                    float f = Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
                    float f1 = Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
                    double animationPosX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                    double animationPosY = 0.0;
                    double animationPosZ = radius * Mth.m_14089_((float)angle);
                    livingentity.m_6027_(this.mob.m_20185_() + (double)(f * math) + animationPosX, this.mob.m_20186_() + animationPosY, this.mob.m_20189_() + (double)(f1 * math) + animationPosZ);
                }
            } else if (this.type == 7) {
                float radius = (float)(this.mob.timer == 6 ? 2.25 : (this.mob.timer == 7 ? 0.2 : (this.mob.timer == 8 ? -2.25 : (this.mob.timer > 8 ? -2.25 : 2.25))));
                float math = 0.175f;
                float angle = (float)Math.PI / 180 * this.mob.m_146908_();
                float f = Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
                float f1 = Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
                double animationPosX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double animationPosY = this.mob.timer == 6 ? 0.25 : (this.mob.timer == 7 ? 2.2 : (this.mob.timer == 8 ? 2.5 : (this.mob.timer == 9 ? 2.05 : 0.0)));
                double animationPosZ = radius * Mth.m_14089_((float)angle);
                BlockPos blockPos = new BlockPos(this.mob.m_20185_() + (double)(f * math) + animationPosX, this.mob.m_20186_() + animationPosY, this.mob.m_20189_() + (double)(f1 * math) + animationPosZ);
                for (int i = 0; i < 30 && !this.mob.f_19853_.m_46859_(blockPos); ++i) {
                    blockPos = blockPos.m_7918_(0, 1, 0);
                }
                if (this.target != null) {
                    this.target.m_20035_(blockPos, 0.0f, 0.0f);
                    if (this.mob.timer == 10) {
                        this.mob.setNoDamages(this.inv);
                        if (!this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), (float)(this.mob.m_21133_(Attributes.f_22281_) * (double)1.35f))) {
                            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob).m_19380_(), CombatRules.m_19272_((float)((float)(this.mob.m_21133_(Attributes.f_22281_) * (double)1.35f)), (float)this.target.m_21230_(), (float)((float)this.target.m_21133_(Attributes.f_22285_))));
                        }
                        this.mob.m_21335_(null);
                    }
                } else {
                    this.mob.timer = 16;
                }
                if (this.mob.timer < 10) {
                    this.mob.setNoDamages(true);
                }
                this.hasNext = false;
            } else {
                if (this.mob.timer == 5) {
                    this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
                    CombatEvent.AreaAttack((LivingEntity)this.mob, 5.0f, 5.0f, 5.0f, 5.0f, 170.0f, 0.65f, 0.0, 0.5, false);
                }
                this.moving(3);
                this.hasNext = this.type < 12;
            }
            this.dodgeYaw = (float)Math.toRadians(this.mob.f_20883_ % 360.0f + 90.0f + this.mob.m_217043_().m_188501_() * 150.0f - 75.0f);
        }

        private void moving(int i) {
            if (this.mob.timer == i) {
                this.mob.m_20256_(this.mob.m_20184_().m_82520_((this.mob.m_5448_().m_20185_() - this.mob.m_20185_()) / Math.PI, 0.0, (this.mob.m_5448_().m_20189_() - this.mob.m_20189_()) / Math.PI));
            }
        }

        public void m_8041_() {
            this.type = 1;
            this.cooldown = this.mob.f_19797_ + 10;
            this.mob.f_19804_.m_135381_(IS_MELEE, (Object)false);
            this.mob.setNoDamages(this.inv);
            if (this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && (this.mob.aiPower >= 2 || !this.mob.m_20096_())) {
                float speed = -1.0f;
                Vec3 m = this.mob.m_20184_().m_82520_((double)speed * Math.cos(this.dodgeYaw), 0.0, (double)speed * Math.sin(this.dodgeYaw));
                this.mob.m_20334_(m.f_82479_, 0.1, m.f_82481_);
            }
        }
    }

    static class PullOutWeaponGoal
    extends Goal {
        private final SpearmanMasterEntity mob;

        public PullOutWeaponGoal(SpearmanMasterEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) == false && (Boolean)this.mob.f_19804_.m_135370_(IS_RUN) == false;
        }

        public boolean m_6767_() {
            return this.mob.timer >= 10;
        }

        public boolean m_8045_() {
            return this.mob.timer < 10;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_PULLING_OUT_WEAPON, (Object)true);
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_PULLED_OUT_WEAPON, (Object)true);
            this.mob.f_19804_.m_135381_(IS_PULLING_OUT_WEAPON, (Object)false);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
        }
    }

    static class WithdrawWeaponGoal
    extends Goal {
        private final SpearmanMasterEntity mob;

        public WithdrawWeaponGoal(SpearmanMasterEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() == null && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false && this.mob.m_217043_().m_188503_(35) == 0;
        }

        public boolean m_8045_() {
            return this.mob.timer < 11;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_PULLING_OUT_WEAPON, (Object)true);
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_PULLED_OUT_WEAPON, (Object)false);
            this.mob.f_19804_.m_135381_(IS_PULLING_OUT_WEAPON, (Object)false);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
        }
    }

    static class SpearmanMeleeGoal
    extends MeleeAttackGoal {
        protected SpearmanMasterEntity spearmanEntity;
        protected boolean isRushTowardsTarget;
        protected boolean isDoHurtTarget;
        protected boolean isRunning;
        protected int doHurtTargetType;
        protected int attackCooldown;
        private int delayCounter;

        public SpearmanMeleeGoal(SpearmanMasterEntity p_25552_, double p_25553_, boolean p_25554_) {
            super((PathfinderMob)p_25552_, p_25553_, p_25554_);
            this.spearmanEntity = p_25552_;
            this.attackCooldown = 0;
        }

        public boolean m_8036_() {
            return super.m_8036_() && (Boolean)this.spearmanEntity.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false;
        }

        public void m_8056_() {
            super.m_8056_();
            this.spearmanEntity.timer = 0;
            this.isRushTowardsTarget = false;
            this.isDoHurtTarget = false;
            this.isRunning = false;
            this.doHurtTargetType = 0;
        }

        public void m_8041_() {
            super.m_8041_();
            AttributeInstance modifiableattributeinstance = this.spearmanEntity.m_21051_(Attributes.f_22279_);
            this.spearmanEntity.timer = 0;
            this.isDoHurtTarget = false;
            this.isRunning = false;
            this.doHurtTargetType = 0;
            modifiableattributeinstance.m_22130_(SPEED_MODIFIER_RUN);
        }

        public void m_8037_() {
            AttributeInstance modifiableattributeinstance = this.spearmanEntity.m_21051_(Attributes.f_22279_);
            if (this.spearmanEntity.m_5448_() != null) {
                this.spearmanEntity.f_19804_.m_135381_(IS_MELEE, (Object)false);
                if (this.attackCooldown <= 0) {
                    super.m_8037_();
                    if ((double)this.spearmanEntity.m_20270_((Entity)this.spearmanEntity.m_5448_()) > 9.5 && this.spearmanEntity.aiPower >= 2) {
                        if (!modifiableattributeinstance.m_22109_(SPEED_MODIFIER_RUN)) {
                            modifiableattributeinstance.m_22118_(SPEED_MODIFIER_RUN);
                        }
                        this.isRunning = true;
                    } else {
                        if (modifiableattributeinstance.m_22109_(SPEED_MODIFIER_RUN)) {
                            modifiableattributeinstance.m_22130_(SPEED_MODIFIER_RUN);
                        }
                        this.isRunning = false;
                    }
                    this.spearmanEntity.f_19804_.m_135381_(IS_RUN, (Object)this.isRunning);
                    if (!this.isRushTowardsTarget) {
                        this.isRushTowardsTarget = (double)this.spearmanEntity.m_20270_((Entity)this.spearmanEntity.m_5448_()) < 8.5 && this.spearmanEntity.m_217043_().m_188503_(375) == 0;
                    }
                } else {
                    --this.attackCooldown;
                    LivingEntity livingentity = this.spearmanEntity.m_5448_();
                    this.spearmanEntity.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                    if (--this.delayCounter <= 0) {
                        this.delayCounter = 8 + this.spearmanEntity.m_217043_().m_188503_(5);
                        if ((double)this.spearmanEntity.m_20270_((Entity)livingentity) <= 5.1) {
                            this.spearmanEntity.m_21573_().m_26519_(livingentity.m_20185_() + (double)livingentity.m_217043_().m_188503_(1) * (livingentity.m_217043_().m_188499_() ? 1.14 : -1.14), livingentity.m_20186_(), livingentity.m_20189_() + (double)livingentity.m_217043_().m_188503_(1) * (livingentity.m_217043_().m_188499_() ? 1.14 : -1.14), 1.15 - ((double)this.spearmanEntity.m_21573_().m_26570_().m_77407_() <= 2.5 ? 0.5 : 0.0));
                            this.delayCounter = 18 + this.spearmanEntity.m_217043_().m_188503_(12);
                        } else if ((double)this.spearmanEntity.m_20270_((Entity)livingentity) >= 7.6) {
                            this.spearmanEntity.m_21573_().m_5624_((Entity)livingentity, 1.1);
                        }
                        if ((double)this.spearmanEntity.m_20270_((Entity)livingentity) >= 5.5 && (double)this.spearmanEntity.m_20270_((Entity)livingentity) <= 7.5) {
                            this.spearmanEntity.m_21573_().m_26573_();
                        }
                    }
                }
            }
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            if (distToEnemySqr + 64.0 + (double)enemy.m_20205_() <= (double)this.spearmanEntity.m_20270_((Entity)enemy) || this.spearmanEntity.m_20191_().m_82381_(enemy.m_20191_().m_82400_(3.5)) || this.spearmanEntity.m_20191_().m_82381_(enemy.m_20191_().m_82377_(4.0, 2.0, 4.0))) {
                this.spearmanEntity.f_19804_.m_135381_(CAN_MELEE, (Object)true);
                this.spearmanEntity.timer = 0;
                this.isDoHurtTarget = true;
            }
        }
    }
}

